<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../gUtil/GestoreTabella.php";
    include "../../../classi/Tabella.php";
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    
    $parametriRicerca = $cerca!="" ? array("nome"=>$cerca) : array();
    $parametri = array("tabella"=>"geec_articoliDalBlog", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Amministrazione di Geecom CMS - componente articoli dal blog</title>

    <?php
        include "../include/cssBaseComponenti.php";
    ?>
</head>

<body>
   
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
        
    ?>
    
    <!-- Modal box creazione amministratore-->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            <h4 class="modal-title" id="myModalLabel">Crea un nuovo utente</h4>
          </div>
          <div class="modal-body">
            <form class="form-horizontal" role="form" name="modalForm" action="utenti/creaUtente.php" method="post">
          <div class="form-group">
            <label for="campoTesto1" class="col-sm-3 control-label">Nome</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="campoTesto1" name="nome" placeholder="Nome">
            </div>
          </div>
          
          <div class="form-group">
            <label for="campoTesto1" class="col-sm-3 control-label">Cognome</label>
            <div class="col-sm-9">
              <input type="text" class="form-control" id="campoTesto1" name="cognome" placeholder="Cognome">
            </div>
          </div>
                
          <div class="form-group">
            <label for="inputEmail3" class="col-sm-3 control-label">Email</label>
            <div class="col-sm-9">
              <input type="email" class="form-control" id="inputEmail3" name="email" placeholder="Email">
            </div>
          </div>
          
          <div class="form-group">
            <label for="inputEmail3" class="col-sm-3 control-label">Password</label>
            <div class="col-sm-9">
              <input type="email" class="form-control" name="password" placeholder="Password">
            </div>
          </div>
          
          <input type="text" class="hidden" name="idUtente" value="0">
          
          <div class="form-group">
            <label for="selectEsempio1"class="col-sm-3 control-label">Ruolo</label>
            <div class="col-sm-4">
            <select class="form-control" name="ruolo">
                <option value="articolista">articolista</option>
                <option value="amministratore">amministratore</option>
                <option value="super admin">super admin</option>
            </select>
            </div>
           </div>
        </form>
          </div>
          
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Chiudi</button>
            <button type="button" class="btn btn-primary" onclick={document.modalForm.submit();}>Crea utente</button>
          </div>
        </div><!-- /.modal-content -->
      </div><!-- /.modal-dialog -->
    </div><!-- /.Modal box-->

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <?php
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==1) {
                                    echo"<p class=\"alert alert-success\">Utente creato</p>";
                            }
                            else if($_GET["status"]==2) {
                                    echo"<p class=\"alert alert-success\">Utente modificato</p>";
                            }
                            else if($_GET["status"]==4) {
                                    echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                            }
                            else if($_GET["status"]==400) {
                                    echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                            }
                            else { //status = 5
                                    echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                            }
                        }
                    ?>
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header">
                            <span class="card-title mr-2"> Elenco visualizzatori articoli dal blog</span> 
                            <a href="creaArticoliDalBlog.php" class="btn btn-sm btn-primary" >
                                Nuova visualizzatore di articoli<i class="fas fa-plus ml-2"></i>
                            </a>
                        </div>
                        <div class="panel panel-default">
                            <div class="card-body collapse show">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca);
                                        $ricerca->stampaFormRicerca($cerca);
                                    ?>
                                </div>
                                <div class="table-responsive table-sm">
                                    <?php
                                        if(isset($_GET["pag"])) {
                                            $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                        }
                                        else {
                                            $ris = $ricerca->eseguiRicerca(1);
                                        }

                                        $colonne = array("ID","Nome","Numero articoli","Mostra immagini","Mostra testo","");
                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                        $tabella->setTipo("normale");
                                        while($articoliDalBlog = $ris->fetch_assoc()) {
                                            $nomeEscape = filter_var($articoliDalBlog["nome"],FILTER_SANITIZE_ADD_SLASHES);
                                            $azioni = array("modifica"=>"creaArticoliDalBlog.php?id={$articoliDalBlog["id"]}","elimina"=>"eliminaOccorrenza({$articoliDalBlog["id"]},'$nomeEscape')");
                                            $tabella->aggiungiNuovaRiga(array($articoliDalBlog["id"],"<a href=\"creaArticoliDalBlog.php?id={$articoliDalBlog["id"]}\"><b>{$articoliDalBlog["nome"]}</b></a>",$articoliDalBlog["numeroArticoli"],$articoliDalBlog["mostraImmagini"],$articoliDalBlog["mostraTesto"]),$azioni);
                                        }

                                        $tabella->stampa("form", 0);
                                        $ricerca->stampaPaginazione(true,"index.php");

                                    ?>
                                </div>
                            </div>
                            <!-- /tabella -->
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
    
    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
        
        include "../../include/modal/operazioneCompletata.php";
   
        include "../include/modal/eliminaOccorrenza.php";
        
        include "../include/jsBaseComponenti.php";
    ?>
   
    <script type="text/javascript">

        function eliminaOccorrenza(id,nome) {
            document.getElementById("elementoDaEliminare").value = id;
            document.getElementById("nomeElementoDaEliminare").innerHTML = nome;
            $('#modalEliminaOccorrenza').modal('show');
        }
        
        function eseguiEliminazioneOccorrenza() {
            var id = $('#elementoDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"controller/controllerComponente.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(result) {
                    if(result=="ok") {
                        document.getElementById("form"+id).className = "d-none";
                        $('#modalEliminaOccorrenza').modal('hide');
                    }
                    else {
                        alert(result);
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
    </script>
</body>
</html>